/*****************************************************************************
 *   dma.h:  Header file for NXP LPC29xx Family Microprocessors
 *
 *   Copyright(C) 2009, NXP Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2009.12.17  ver 1.00    Preliminary version, first Release
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 *****************************************************************************/

#ifndef __DMA_H 
#define __DMA_H

#define DMA_SRC			0x80008000
//#define DMA_DST			0x8000A000			// IRAM2
#define DMA_DST			0xF0400000			// DTCM
#define DMA_SIZE		0x1000

#define M2M				0x00
#define M2P				0x01
#define P2M				0x02
#define P2P				0x03

typedef struct _LinkedList {
    DWORD   SRC;
    DWORD   DST;  		
    DWORD   LLI;
    DWORD   CTRL;
}LinkedList;


extern void DMAHandler (void);
extern DWORD DMA_Init( FOC_STRUCT *src );

#endif /* end __DMA_H */
/****************************************************************************
**                            End Of File
****************************************************************************/
